//-----------------------------------------------------------------------
// Version:        2.2.1
// Template name:  Finapp - Wallet & Banking HTML Mobile Template
// Item URL :      https://themeforest.net/item/finapp-wallet-banking-html-mobile-template/25738217
// Author:         Bragher
// Author URL :    https://themeforest.net/user/bragher
//-----------------------------------------------------------------------

//-----------------------------------------------------------------------
// Template Settings
//-----------------------------------------------------------------------
const Finapp = {
    //-------------------------------------------------------------------
    // PWA Settings
    PWA: {
        enable: true, // Enable or disable PWA
    },
    //-------------------------------------------------------------------
    // Dark Mode Settings
    Dark_Mode: {
        default: false, // Set dark mode as main theme
        local_mode: { // Activate dark mode between certain times of the day
            enable: false, // Enable or disable local dark mode
            start_time: 20, // Start at 20:00
            end_time: 7, // End at 07:00
        },
        auto_detect: { // Auto detect user's preferences and activate dark mode
            enable: false,
        }
    },
    //-------------------------------------------------------------------
    // Right to Left (RTL) Settings
    RTL: {
        enable: false, // Enable or disable RTL Mode
    },
    //-------------------------------------------------------------------
    // Animations
    Animation: {
        goBack: false, // Go back page animation
    },
    //-------------------------------------------------------------------
    // Test Mode
    Test: {
        enable: true, // Enable or disable test mode
        word: "testmode", // The word that needs to be typed to activate test mode
        alert: true, // Enable or disable alert when test mode is activated
        alertMessage: "Test mode activated. Look at the developer console!" // Alert message
    }
    //-------------------------------------------------------------------
}
//-----------------------------------------------------------------------


if (navigator.userAgent.match(/Android/i)
 || navigator.userAgent.match(/webOS/i)
 || navigator.userAgent.match(/iPhone/i)
 || navigator.userAgent.match(/iPad/i)
 || navigator.userAgent.match(/iPod/i)
 || navigator.userAgent.match(/BlackBerry/i)
 || navigator.userAgent.match(/Windows Phone/i)) {
    bMobile = true;
    //console.log("bMobile: " + true);
 } else {
    bMobile = false ;
    //console.log("bMobile: " + false);
 }

const isInStandaloneMode = () =>
      (window.matchMedia('(display-mode: standalone)').matches) || (window.navigator.standalone) || document.referrer.includes('android-app://');
//-----------------------------------------------------------------------
// Push Notification
const notificationButton = document.getElementById("enableNotifications");
let swRegistration = null;
let w;

//initializeApp();

function initializeUi() {
  notificationButton.addEventListener("click", () => {
    displayNotification();
  });
}

function displayNotification() {
  if (window.Notification && Notification.permission === "granted") {
    notificationPWA();
  }
  // If the user hasn't told if he wants to be notified or not
  // Note: because of Chrome, we are not sure the permission property
  // is set, therefore it's unsafe to check for the "default" value.
  else if (window.Notification && Notification.permission !== "denied") {
    Notification.requestPermission(status => {
      if (status === "granted") {
        //requestPermission();
        notificationPWA();
      } else {
        alert("You denied or dismissed permissions to notifications.");
      }
    });
  } else {
    // If the user refuses to get notified
    alert(
      "You denied permissions to notifications. Please go to your browser or phone setting to allow notifications."
    );
  }
}

function notificationPWA(tit, val) {
  var sVal = "Testing Our Notification", sTitle = "Yes2D";

  if (tit !== undefined) {
      sTitle = tit;
  }
  
  if (val) {
      sVal = val;
  }
  
  const options = {
    body: val,
    icon: ""
  };
  
  //Check shownotification: some browser not working
  if (typeof swRegistration.showNotification !== 'undefined') {
      swRegistration.showNotification(sTitle, options);
  }
  else {
    Notification.requestPermission(function (permission) {
        // If the user accepts, let's create a notification
        if (permission === "granted") {
            var notification = new Notification(sTitle, options);
        }
    });
  }
  
}

//-----------------------------------------------------------------------
// Elements
//-----------------------------------------------------------------------
var pageBody = document.querySelector("body");
var appSidebar = document.getElementById("sidebarPanel")
var loader = document.getElementById('loader');
//-----------------------------------------------------------------------


function isPushNotificationSupported() {
  //return "serviceWorker" in navigator && "PushManager" in window;
  return "serviceWorker" in navigator;
}

function registerServiceWorker() {
  navigator.serviceWorker.register("sw.js?20230507_1").then(function(swRegistration) {
    //you can do something with the service wrker registration (swRegistration)
    console.log("here start?");
  });
}

//-----------------------------------------------------------------------
// Service Workers
//-----------------------------------------------------------------------
if (Finapp.PWA.enable) {
    if (typeof messaging !== typeof undefined) {
        if (messaging !== null) {
            if (!isTokenSentToServer()) {
                messaging.requestPermission()
                  .then(() => {
                    //console.log("Notifications allowed");
                    //alert("Notifications allowed");
                    return messaging.getToken();
                  })
                  .then(token => {
                    //console.log("Token Is : " + token);
                    //alert(token);
                    resetUI();
                  })
                  .catch(err => {
                    //errorMessage.innerHTML = errorMessage.innerHTML + "; " + err;
                    //console.log("No permission to send push", err);
                  });
            }
        }
    }

    if (localStorage.getItem("Y2dNotification") == 1) {
       if (typeof(w) == "undefined") {
            w = new Worker("worker.js?20230508_2");
            console.log("connect");
            //alert("connect worker!");
        }
        w.postMessage({
            myFunction: sCid,
            myNotif: localStorage.getItem("Y2dNotification")
        });
        w.onmessage = function(event) {
            //alert("worker - back");
            if (event !== undefined) {
                var iFlag = event.data;
                //alert("iFlag: " + iFlag);
                console.log("iFlag: " + iFlag);
                if (iFlag > 0) {
                    bgNotify_transfer();
                }
            }
        };
    }
    
    if (!isPushNotificationSupported()) {
        alert("Browser Not support notification.");
    }
    
    if('serviceWorker' in navigator){
       // registers the service worker file with the filename
       navigator.serviceWorker.register('sw.js?20230507_1')
       .then(reg => {
            console.log('service worker registered', reg);
            swRegistration = reg;
            initializeUi();
        })
        .catch(err => {
            console.log('service worker not registered - there is an error.', err);
            //alert('service worker not registered - there is an error.');
        });
    }
}
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Page Loader with preload
//----------------------------------------------------------------------
setTimeout(() => {
    loader.setAttribute("style", "pointer-events: none; opacity: 0; transition: 0.2s ease-in-out;");
    
    //
    if (typeof document.URL !== 'undefined') {
        console.log(document.URL);
        if (document.URL !== 'https://yes2d888.com/games_bg') {
            console.log("Not gamebg");
            setTimeout(() => {
                loader.setAttribute("style", "display: none;");
            }, 2000);
        }
        else {
            console.log("is gamebg");
            setTimeout(() => {
                loader.setAttribute("style", "display: none;");
            }, 4000);
        }
    }
    
    
}, 450);
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Go Back Animation
function goBackAnimation() {
    pageBody.classList.add("animationGoBack")
    setTimeout(() => {
        window.history.go(-1);
    }, 300);
}
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// RTL (Right to Left)
if (Finapp.RTL.enable) {
    var pageHTML = document.querySelector("html")
    pageHTML.dir = "rtl"
    document.querySelector("body").classList.add("rtl-mode")
    if (appSidebar != null) {
        appSidebar.classList.remove("panelbox-left")
        appSidebar.classList.add("panelbox-right")
    }
    document.querySelectorAll(".carousel-full, .carousel-single, .carousel-multiple, .carousel-small, .carousel-slider").forEach(function (el) {
        el.setAttribute('data-splide', '{"direction":"rtl"}')
    })
}
//-----------------------------------------------------------------------

//-----------------------------------------------------------------------
// Input
// Clear input
var clearInput = document.querySelectorAll(".clear-input");
clearInput.forEach(function (el) {
    el.addEventListener("click", function () {
        var parent = this.parentElement
        var input = parent.querySelector(".form-control")
        input.focus();
        input.value = "";
        parent.classList.remove("not-empty");
    })
})
// active
var formControl = document.querySelectorAll(".form-group .form-control");
formControl.forEach(function (el) {
    // active
    el.addEventListener("focus", () => {
        var parent = el.parentElement
        parent.classList.add("active")
    });
    el.addEventListener("blur", () => {
        var parent = el.parentElement
        parent.classList.remove("active")
    });
    // empty check
    el.addEventListener("keyup", log);
    function log(e) {
        var inputCheck = this.value.length;
        if (inputCheck > 0) {
            this.parentElement.classList.add("not-empty")
        }
        else {
            this.parentElement.classList.remove("not-empty")
        }
    }
})
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Searchbox Toggle
var searchboxToggle = document.querySelectorAll(".toggle-searchbox")
searchboxToggle.forEach(function (el) {
    el.addEventListener("click", function () {
        var search = document.getElementById("search")
        var a = search.classList.contains("show")
        if (a) {
            search.classList.remove("show")
        }
        else {
            search.classList.add("show")
            search.querySelector(".form-control").focus();
        }
    })
});
//-----------------------------------------------------------------------

//-----------------------------------------------------------------------
// Upload Input
var uploadComponent = document.querySelectorAll('.custom-file-upload');
uploadComponent.forEach(function (el) {
    var fileUploadParent = '#' + el.id;
    var fileInput = document.querySelector(fileUploadParent + ' input[type="file"]')
    var fileLabel = document.querySelector(fileUploadParent + ' label')
    var fileLabelText = document.querySelector(fileUploadParent + ' label span')
    var filelabelDefault = fileLabelText.innerHTML;
    fileInput.addEventListener('change', function (event) {
        var name = this.value.split('\\').pop()
        tmppath = URL.createObjectURL(event.target.files[0]);
        if (name) {
            fileLabel.classList.add('file-uploaded');
            fileLabel.style.backgroundImage = "url(" + tmppath + ")";
            fileLabelText.innerHTML = name;
        }
        else {
            fileLabel.classList.remove("file-uploaded")
            fileLabelText.innerHTML = filelabelDefault;
        }
    })
})
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Notification
// trigger notification
var notificationCloseButton = document.querySelectorAll(".notification-box .close-button");
var notificationTaptoClose = document.querySelectorAll(".tap-to-close .notification-dialog");
var notificationBox = document.querySelectorAll(".notification-box");

function closeNotificationBox() {
    notificationBox.forEach(function (el) {
        el.classList.remove("show")
    })
}
function notification(target, time) {
    var a = document.getElementById(target);
    closeNotificationBox()
    setTimeout(() => {
        a.classList.add("show")
    }, 250);
    if (time) {
        time = time + 250;
        setTimeout(() => {
            closeNotificationBox()
        }, time);
    }
}
// close notification
notificationCloseButton.forEach(function (el) {
    el.addEventListener("click", function (e) {
        e.preventDefault();
        closeNotificationBox();
    })
});

// tap to close notification
notificationTaptoClose.forEach(function (el) {
    el.addEventListener("click", function (e) {
        closeNotificationBox();
    })
});
//-----------------------------------------------------------------------

//-----------------------------------------------------------------------
// Add to Home
var osDetection = navigator.userAgent || navigator.vendor || window.opera;
var windowsPhoneDetection = /windows phone/i.test(osDetection);
var androidDetection = /android/i.test(osDetection);
var iosDetection = /iPad|iPhone|iPod/.test(osDetection) && !window.MSStream;

function iosAddtoHome() {
    var modal = new bootstrap.Modal(document.getElementById('ios-add-to-home-screen'))
    modal.toggle()
}
function androidAddtoHome() {
    var modal = new bootstrap.Modal(document.getElementById('android-add-to-home-screen'))
    modal.toggle()
}

function forceLogout(sMsg) {
    var AddHomeStatus = localStorage.getItem("Y2dAppAddtoHome"), NotifSwitch = localStorage.getItem("Y2dNotification");
    
    if (typeof sCid !== undefined && sCid !== null) {
        firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
          const iLogin = parseInt(snapshot.val().bLogin);
          if (iLogin == 1) firebase.database().ref("Customer/User/" + sCid).update({bLogin: 0})
          
          //firebase.database().ref("Customer/User/6722").update({AngpaoNoti: 1})
          //firebase.database().ref("Customer/User/12215").update({GiftboxNoti: 1})
        });
    }
    
    localStorage.clear();
    if (NotifSwitch == '' || NotifSwitch == undefined) NotifSwitch = 0;
    if (typeof sMsg !== undefined || typeof sMsg !== typeof undefined) localStorage.setItem("yes2dMessage", sMsg);
    localStorage.setItem("Y2dAppAddtoHome", AddHomeStatus);
    localStorage.setItem("Y2dNotification", NotifSwitch);

    window.location = '/reset';
    
    AddHomeStatus = undefined;
    NotifSwitch = undefined;
}

function AddtoHome(time, once) {
    if (once) {
        var AddHomeStatus = localStorage.getItem("Y2dAppAddtoHome");
        if (AddHomeStatus === "1" || AddHomeStatus === 1) {
            // already showed up
        }
        else {
            localStorage.setItem("Y2dAppAddtoHome", 1);
            window.addEventListener('load', () => {
                if (navigator.standalone) {
                    // if app installed ios home screen
                }
                else if (matchMedia('(display-mode: standalone)').matches) {
                    // if app installed android home screen
                }
                else {
                    // if app is not installed
                    if (androidDetection) {
                        setTimeout(() => {
                            androidAddtoHome()
                        }, time);
                    }
                    if (iosDetection) {
                        setTimeout(() => {
                            iosAddtoHome()
                        }, time);
                    }
                }
            });
        }
    }
    else {
        window.addEventListener('load', () => {
            if (navigator.standalone) {
                // app loaded to ios
            }
            else if (matchMedia('(display-mode: standalone)').matches) {
                // app loaded to android
            }
            else {
                // app not loaded
                if (androidDetection) {
                    setTimeout(() => {
                        androidAddtoHome()
                    }, time);
                }
                if (iosDetection) {
                    setTimeout(() => {
                        iosAddtoHome()
                    }, time);
                }
            }
        });
    }

}
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Dark Mode
var checkDarkModeStatus = localStorage.getItem("FinappDarkmode");
var switchDarkMode = document.querySelectorAll(".dark-mode-switch");
var pageBodyActive = pageBody.classList.contains("dark-mode");

// Check if enable as default
if (Finapp.Dark_Mode.default) {
    pageBody.classList.add("dark-mode");
}

// Local Dark Mode
if (Finapp.Dark_Mode.local_mode.enable) {
    var nightStart = Finapp.Dark_Mode.local_mode.start_time;
    var nightEnd = Finapp.Dark_Mode.local_mode.end_time;
    var currentDate = new Date();
    var currentHour = currentDate.getHours();
    if (currentHour >= nightStart || currentHour < nightEnd) {
        // It is night time
        pageBody.classList.add("dark-mode");
    }
}

// Auto Detect Dark Mode
if (Finapp.Dark_Mode.auto_detect.enable)
    if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
        pageBody.classList.add("dark-mode");
    }

function switchDarkModeCheck(value) {
    switchDarkMode.forEach(function (el) {
        el.checked = value
    })
}
// if dark mode on
if (checkDarkModeStatus === 1 || checkDarkModeStatus === "1" || pageBody.classList.contains('dark-mode')) {
    switchDarkModeCheck(true);
    if (pageBodyActive) {
        // dark mode already activated
    }
    else {
        pageBody.classList.add("dark-mode")
    }
}
else {
    switchDarkModeCheck(false);
}
switchDarkMode.forEach(function (el) {
    el.addEventListener("click", function () {
        var darkmodeCheck = localStorage.getItem("FinappDarkmode");
        var bodyCheck = pageBody.classList.contains('dark-mode');
        if (darkmodeCheck === 1 || darkmodeCheck === "1" || bodyCheck) {
            pageBody.classList.remove("dark-mode");
            localStorage.setItem("FinappDarkmode", "0");
            switchDarkModeCheck(false);
        }
        else {
            pageBody.classList.add("dark-mode")
            switchDarkModeCheck(true);
            localStorage.setItem("FinappDarkmode", "1");
        }
    })
})
//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Cookies Box
if (document.querySelector(".offcanvas") === null) {
    // Doesn't exist.
}
else {
    var elCookiesBox = new bootstrap.Offcanvas(document.getElementById('cookiesbox'));
    var CookiesStatus = localStorage.getItem("FinappCookiesStatus")
    function CookiesBox(time) {
        if (CookiesStatus === "1" || CookiesStatus === 1) {
            // Cookies already accepted.
        }
        else {
            if (time) {
                setTimeout(() => {
                    elCookiesBox.toggle();
                }, time);
            }
            else {
                elCookiesBox.toggle();
            }
        }
    }
    document.querySelectorAll(".accept-cookies").forEach(function (el) {
        el.addEventListener("click", function () {
            localStorage.setItem("FinappCookiesStatus", "1")
        })
    })
}


//-----------------------------------------------------------------------


//-----------------------------------------------------------------------
// Test Mode
function testMode() {
    var colorDanger = "color: #FF396F; font-weight:bold;"
    var colorSuccess = "color: #1DCC70; font-weight:bold;"

    console.clear();
    console.log("%cFINAPP", "font-size: 1.3em; font-weight: bold; color: #FFF; background-color: #6236FF; padding: 10px 120px; margin-bottom: 16px;")
    console.log("%c🚀 TEST MODE ACTIVATED ..!", "font-size: 1em; font-weight: bold; margin: 4px 0;");

    function testModeMsg(value, msg) {
        if (value) {
            console.log("%c|" + "%c " + msg + " : " + "%cEnabled", "color: #444; font-size :1.2em; font-weight: bold;", "color: inherit", colorSuccess);
        }
        else if (value == false) {
            console.log("%c|" + "%c " + msg + " : " + "%cDisabled", "color: #444; font-size :1.2em; font-weight: bold;", "color: inherit", colorDanger);
        }
    }
    function testModeInfo(value, msg) {
        console.log("%c|" + "%c " + msg + " : " + "%c" + value, "color: #444; font-size :1.2em; font-weight: bold;", "color: inherit", "color:#6236FF; font-weight: bold;");
    }
    function testModeSubtitle(msg) {
        console.log("%c # " + msg, "color: #FFF; background: #444; font-size: 1.2em; padding: 8px 16px; margin-top: 16px; border-radius: 12px 12px 0 0");
    }

    testModeSubtitle("THEME SETTINGS")
    testModeMsg(Finapp.PWA.enable, "PWA")
    testModeMsg(Finapp.Dark_Mode.default, "Set dark mode as default theme")
    testModeMsg(Finapp.Dark_Mode.local_mode.enable, "Local dark mode (between " + Finapp.Dark_Mode.local_mode.start_time + ":00 and " + Finapp.Dark_Mode.local_mode.end_time + ":00)")
    testModeMsg(Finapp.Dark_Mode.auto_detect.enable, "Auto detect dark mode")
    testModeMsg(Finapp.RTL.enable, "RTL")
    testModeMsg(Finapp.Test.enable, "Test mode")
    testModeMsg(Finapp.Test.alert, "Test mode alert")

    testModeSubtitle("PREVIEW INFOS")
    // Resolution
    testModeInfo(window.screen.availWidth + " x " + window.screen.availHeight, "Resolution")
    // Device
    if (iosDetection) {
        testModeInfo("iOS", "Device")
    }
    else if (androidDetection) {
        testModeInfo("Android", "Device")
    }
    else if (windowsPhoneDetection) {
        testModeInfo("Windows Phone", "Device")
    }
    else {
        testModeInfo("Not a Mobile Device", "Device")
    }
    //Language
    testModeInfo(window.navigator.language, "Language")
    // Theme
    if (pageBody.classList.contains("dark-mode")) {
        testModeInfo("Dark Mode", "Current theme")
    }
    else {
        testModeInfo("Light Mode", "Current theme")
    }
    // Online Status
    if (window.navigator.onLine) {
        testModeInfo("Online", "Internet connection")
    }
    else {
        testModeInfo("Offline", "Internet connection")
    }

    testModeSubtitle("ANIMATIONS")
    testModeMsg(Finapp.Animation.goBack, "Go Back")
}
function themeTesting() {
    var word = Finapp.Test.word;
    var value = "";
    window.addEventListener('keypress', function (e) {
        value = value + String.fromCharCode(e.keyCode).toLowerCase();
        if (value.length > word.length) {
            value = value.slice(1);
        }
        if (value == word || value === word) {
            value = ""
            if (Finapp.Test.alert) {
                var content = document.getElementById("appCapsule")
                content.appendChild(document.createElement("div")).className = "test-alert-wrapper";
                var alert =
                    "<div id='alert-toast' class='toast-box toast-center tap-to-close'>"
                    +
                    "<div class='in'>"
                    +
                    "<div class='text'><h1 class='text-light mb-05'>🤖</h1><strong>"
                    +
                    Finapp.Test.alertMessage
                    +
                    "</strong></div></div></div>"
                var wrapper = document.querySelector(".test-alert-wrapper")
                wrapper.innerHTML = alert;
                toastbox('alert-toast');
                setTimeout(() => {
                    this.document.getElementById("alert-toast").classList.remove("show")
                }, 4000);
            }
            testMode();
        }

    })
}

if (Finapp.Test.enable) {
    themeTesting();
}
//-----------------------------------------------------------------------

function navRedirect (value) {
    if (value !== null && value !== '') {
        localStorage.setItem("yes2dNav", value);
    }
    return true;
}

function setNavFooter (val) {
    if (val !== null && val !== '') {
        var nav = document.getElementById(val);
        
        if (nav !== null) {
            nav.classList.add("active");
        }
        
        nav = undefined;
    }
}

function sendTokenToServer(currentToken) {
    if (!isTokenSentToServer()) {
      console.log('Sending token to server...');
      //alert('Sending token to server...');
      // TODO(developer): Send the current token to your server.
      setTokenSentToServer(true, currentToken);
    } else {
      console.log('Token already sent to server so won\'t send it again ' +
          'unless it changes');
    }
}

function deleteToken() {
    // Delete registration token.
    messaging.getToken().then((currentToken) => {
      messaging.deleteToken(currentToken).then(() => {
        console.log('Token deleted.');
        setTokenSentToServer(false, 3);
        // Once token is deleted update UI.
        resetUI();
      }).catch((err) => {
        console.log('Unable to delete token. ', err);
      });
    }).catch((err) => {
      console.log('Error retrieving registration token. ', err);
      //showToken('Error retrieving registration token. ', err);
    });
}

function requestPermission() {
    console.log('Requesting permission...');
    Notification.requestPermission().then((permission) => {
      if (permission === 'granted') {
        console.log('Notification permission granted.');
        // TODO(developer): Retrieve a registration token for use with FCM.
        // In many cases once an app has been granted notification permission,
        // it should update its UI reflecting this.
        //resetUI();
        notificationPWA();
      } else {
        console.log('Unable to get permission to notify.');
      }
    });
}

function setTokenSentToServer(sent, curToken) {
    //alert(sent);
    //alert(curToken);
    localStorage.setItem('y2dSentToServer', sent ? '1' : '0');
    if (sent) {
        const NotifToken = curToken;
        //alert(NotifToken);
        
        setTimeout(function() {
            if (typeof sCid !== undefined && sCid !== null && typeof NotifToken !== typeof undefined) {
              var bDevice = (bMobile == true) ? 1 : 0;
              //alert(bDevice);
              $.ajax({
                url: apiUrl + 'app_updNotifTokenPWA',
            	type: "POST",
            	data:  {
            	    cid:sCid,
            	    ctoken:sToken,
            	    cDevice: bDevice,
            	    cnotiftoken: NotifToken
            	},
            	success: function(data){
            		if (data !== undefined) {
            		    var $obj = JSON.parse(data);
            		    //console.log($obj);
            		    if ($obj.status === 1) {
                            //alert('111');
                            //alert('999');
            		    }
            		    else if ($obj.status === 2){
        		            forceLogout($obj.msg);
            		    }
            		    else {
            		        //alert('333');
            		        /*
            		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
            		        
            		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
            		        if ($alertError.length > 0) $alertError[0].click();
            		        
            		        divErrorContent = undefined;
            		        $alertError = undefined;
            		        */
            		    }
            		}
            	},
            	error: function(XMLHttpRequest, textStatus, errorThrown){
            	    
            		console.log(XMLHttpRequest.responseText);
            		console.log(textStatus);
            		console.log(errorThrown);
            	} 	        
            });
            }
            
        }, 500);
    }
}

function isTokenSentToServer() {
    return localStorage.getItem('y2dSentToServer') === '1';
}

function resetUI() {
    // Get registration token. Initially this makes a network call, once retrieved
    // subsequent calls to getToken will return from cache.
    //alert("resetUI");
    const validKey = 'BFRQQ5upJKkV-K9cz-3CpQRa9pgQeTjdT5lWLc7Eg3hf9e5DEx46CthRz6sEMr-ai69Eegfwu5W2yEwsrIhG8OU';
    messaging.getToken({vapidKey: validKey}).then((currentToken) => {
      if (currentToken) {
        sendTokenToServer(currentToken);
        //updateUIForPushEnabled(currentToken);
      } 
      else {
        // Show permission request.
        console.log('No registration token available. Request permission to generate one.');
        // Show permission UI.
        //updateUIForPushPermissionRequired();
        setTokenSentToServer(false, 1);
      }
    }).catch((err) => {
      console.log('An error occurred while retrieving token. ', err);
      //showToken('Error retrieving registration token. ', err);
      //setTokenSentToServer(false, 2);
    });
    
    messaging.onMessage((payload) => {
      console.log('Message received. ', payload);
      // ...
    });
}


$(document).on('click', "#btnNotifApprove", function () {
    var divLoader = document.getElementById("loader");
    if (divLoader !== null) divLoader.style.display="";
    if (typeof sCid !== undefined && typeof sToken !== undefined) {
        $.ajax({
            url: apiUrl + 'getApproveTransferPWA',
        	type: "POST",
        	data:  {
        	    cid:sCid,
        	    ctoken:sToken,
        	    transid: localStorage.getItem("yes2dTransId"),
        	    transref: localStorage.getItem("yes2dTransRef")
        	},
        	success: function(data){
        		if (data !== undefined) {
        		    var $obj = JSON.parse(data);
        		    //console.log($obj);
        		    if ($obj.status === 1) {
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        var divSuccessContent = document.getElementById("divSuccessContent"), $alertSuccess = $('#alertSuccess'),$btnNotifClose = $('#btnNotifClose');
            		        
        		        if (divSuccessContent !== null) divSuccessContent.innerHTML = $obj.msg;
        		        if ($alertSuccess.length > 0) $alertSuccess[0].click();
        		        if ($btnNotifClose.length > 0) $btnNotifClose[0].click();
        		        
        		        localStorage.setItem("yes2dTransRef", "");
    		            localStorage.setItem("yes2dTransId", "");
        		        
        		        firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                          const new_loop=parseInt(snapshot.val().TransferNoti)
                          firebase.database().ref("Customer/User/" + sCid).update({TransferNoti: new_loop-1})
        		        });
        		        
        		        divSuccessContent = undefined;
        		        $alertSuccess = undefined;
        		        divLoader = undefined;
        		        $btnNotifClose = undefined;
        		    }
        		    else if ($obj.status === 2){
    		            forceLogout($obj.msg);
        		    }
        		    else {
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        
        		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
        		        
        		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
        		        if ($alertError.length > 0) $alertError[0].click();
        		        
        		        divErrorContent = undefined;
        		        $alertError = undefined;
        		    }
        		}
        	},
        	error: function(XMLHttpRequest, textStatus, errorThrown){
        		console.log(XMLHttpRequest.responseText);
        		console.log(textStatus);
        		console.log(errorThrown);
        	} 	        
        });
    }
});

$(document).on('click', "#btnNotifReject", function () {
    var divLoader = document.getElementById("loader");
    if (divLoader !== null) divLoader.style.display="";
    if (typeof sCid !== undefined && typeof sToken !== undefined) {
        $.ajax({
            url: apiUrl + 'getRejectTransferPWA',
        	type: "POST",
        	data:  {
        	    ctoken:sToken,
        	    transid: localStorage.getItem("yes2dTransId"),
        	    transref: localStorage.getItem("yes2dTransRef")
        	},
        	success: function(data){
        		if (data !== undefined) {
        		    var $obj = JSON.parse(data);
        		    //console.log($obj);
        		    if ($obj.status === 1) {
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        var divSuccessContent = document.getElementById("divSuccessContent"), $alertSuccess = $('#alertSuccess'), $btnNotifClose = $('#btnNotifClose');
            		        
        		        if (divSuccessContent !== null) divSuccessContent.innerHTML = $obj.msg;
        		        if ($alertSuccess.length > 0) $alertSuccess[0].click();
        		        if ($btnNotifClose.length > 0) $btnNotifClose[0].click();
        		        
        		        localStorage.setItem("yes2dTransRef", "");
    		            localStorage.setItem("yes2dTransId", "");
        		        
        		        firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                          const new_loop=parseInt(snapshot.val().TransferNoti)
                          firebase.database().ref("Customer/User/" + sCid).update({TransferNoti: new_loop-1})
        		        });
        		        
        		        divSuccessContent = undefined;
        		        $alertSuccess = undefined;
        		        divLoader = undefined;
        		        $btnNotifClose = undefined;
        		    }
        		    else if ($obj.status === 2){
    		            forceLogout($obj.msg);
        		    }
        		    else {
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        
        		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
        		        
        		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
        		        if ($alertError.length > 0) $alertError[0].click();
        		        
        		        divErrorContent = undefined;
        		        $alertError = undefined;
        		    }
        		}
        	},
        	error: function(XMLHttpRequest, textStatus, errorThrown){
        		console.log(XMLHttpRequest.responseText);
        		console.log(textStatus);
        		console.log(errorThrown);
        	} 	        
        });
    }
});

function bgNotify_transfer() {
    $.ajax({
        url: apiUrl + 'getTransferNotificationPWA',
    	type: "POST",
    	data:  {
    	    cid:sCid,
    	    ctoken:sToken,
    	},
    	success: function(data){
    		if (data !== undefined) {
    		    var $obj = JSON.parse(data);
    		    //console.log($obj);
    		    if ($obj.status === 1) {
    		        if (typeof $obj.from_customer_username !== undefined && typeof $obj.withdraw_amount !== undefined, typeof $obj.trans_ref !== undefined,
    		        typeof $obj.trans_id !== undefined) {
    		            var sNotifMsg = '', sNotifTitle = 'Yes2D Transfer Notification';
    		            
    		            sNotifMsg = "You have receive RM "+ $obj.withdraw_amount + " From User " + $obj.from_customer_username;
    		            
    		            notificationPWA(sNotifTitle, sNotifMsg);
    		            
    		            sNotifMsg = undefined;
    		            sNotifTitle = undefined;
    		        }
    		    }
    		    $obj = undefined;
    		}
    	},
    	error: function(XMLHttpRequest, textStatus, errorThrown){
    		console.log(XMLHttpRequest.responseText);
    		console.log(textStatus);
    		console.log(errorThrown);
    	} 	        
    });
}

function notify_transfer() {
    $.ajax({
        url: apiUrl + 'getTransferNotificationPWA',
    	type: "POST",
    	data:  {
    	    cid:sCid,
    	    ctoken:sToken,
    	},
    	success: function(data){
    		if (data !== undefined) {
    		    var $obj = JSON.parse(data);
    		    //console.log($obj);
    		    if ($obj.status === 1) {
    		        if (typeof $obj.from_customer_username !== undefined && typeof $obj.withdraw_amount !== undefined, typeof $obj.trans_ref !== undefined,
    		        typeof $obj.trans_id !== undefined) {
    		            localStorage.setItem("yes2dTransRef", $obj.trans_ref);
    		            localStorage.setItem("yes2dTransId", $obj.trans_id);
    		            
    		            var hNotifTitle = document.getElementById("hNotifTitle"), divNotifContent = document.getElementById("divNotifContent"),
                        spNotifUsername = document.getElementById("spNotifUsername"), spNotifAmt = document.getElementById("spNotifAmt"), $notibox = $('#notibox');
                        
                        if ($notibox.length > 0) {
                            if (hNotifTitle !== null) hNotifTitle.innerHTML = "Transfer (" + $obj.trans_ref + ")";
                            if (spNotifUsername !== null) spNotifUsername.innerHTML = $obj.from_customer_username;
                            if (spNotifAmt !== null) spNotifAmt.innerHTML = $obj.withdraw_amount + " coin";
                            $notibox[0].click();
                        }
                        
                        $notibox = undefined;
                        hNotifTitle = undefined;
                        divNotifContent = undefined;
                        spNotifUsername = undefined;
                        spNotifAmt = undefined;
    		        }
    		    }
    		    else if ($obj.status === 2){
		            forceLogout($obj.msg);
    		    }
    		    else {
    		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
    		        
    		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
    		        if ($alertError.length > 0) $alertError[0].click();
    		        
    		        divErrorContent = undefined;
    		        $alertError = undefined;
    		    }
    		}
    	},
    	error: function(XMLHttpRequest, textStatus, errorThrown){
    		console.log(XMLHttpRequest.responseText);
    		console.log(textStatus);
    		console.log(errorThrown);
    	} 	        
    });
}

$(document).on('click', "#btnClaimAngpao", function () {
    var divLoader = document.getElementById("loader"), $btnAngpaoClose = $('#btnAngpaoClose');
    if (divLoader !== null) divLoader.style.display="";
    
    if (typeof sCid !== undefined && typeof sToken !== undefined) {
        $.ajax({
            url: apiUrl + 'getApproveAngpaoPWA',
        	type: "POST",
        	data:  {
        	    cid:sCid,
        	    ctoken:sToken,
        	    angpaoid: localStorage.getItem("yes2dAngpaoId")
        	},
        	success: function(data){
        		if (data !== undefined) {
        		    var $obj = JSON.parse(data);
        		    //console.log($obj);
        		    if ($obj.status === 1) {
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        var divSuccessContent = document.getElementById("divSuccessContent"), $alertSuccess = $('#alertSuccess'), divYescoin = document.getElementById("yescoin"),
        		        $alertAngpaoReceived = $('#alertAngpaoReceived');
            		        
        		        if (divSuccessContent !== null) divSuccessContent.innerHTML = $obj.msg;
        		        //if ($alertSuccess.length > 0) $alertSuccess[0].click();
        		        if ($btnAngpaoClose.length > 0) $btnAngpaoClose[0].click();
        		        if (typeof $obj.latest_balance !== typeof undefined) {
        		            if (divYescoin !== null) divYescoin.innerHTML = $obj.latest_balance;    
        		        }

                        if ($alertAngpaoReceived.length > 0) $alertAngpaoReceived[0].click();

        		        localStorage.setItem("yes2dAngpaoId", '');
                        localStorage.setItem("yes2dAngpaoAmount", '');
        		        
        		        firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                          const new_loop=parseInt(snapshot.val().AngpaoNoti)
                          firebase.database().ref("Customer/User/" + sCid).update({AngpaoNoti: new_loop-1})
        		        });
        		        
        		        $alertAngpaoReceived = undefined;
        		        divSuccessContent = undefined;
        		        $alertSuccess = undefined;
        		        divLoader = undefined;
        		    }
        		    else if ($obj.status === 2){
    		            forceLogout($obj.msg);
        		    }
        		    else {
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        
        		        if ($btnAngpaoClose.length > 0) $btnAngpaoClose[0].click();
        		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
        		        
        		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
        		        if ($alertError.length > 0) $alertError[0].click();
        		        
        		        divErrorContent = undefined;
        		        $alertError = undefined;
        		    }
        		}
        	},
        	error: function(XMLHttpRequest, textStatus, errorThrown){
        		console.log(XMLHttpRequest.responseText);
        		console.log(textStatus);
        		console.log(errorThrown);
        	} 	        
        });
    }
});

$(document).on('click', "#btnCancelAngpao", function () {
    var divLoader = document.getElementById("loader"), $btnAngpaoClose = $('#btnAngpaoClose');
    if (divLoader !== null) divLoader.style.display="";
    if ($btnAngpaoClose.length > 0) $btnAngpaoClose[0].click();
    if (divLoader !== null) divLoader.style.display="none";
    localStorage.setItem("yes2dAngpaoId", '');
    localStorage.setItem("yes2dAngpaoAmount", '');
});

$(document).on('click', "#btnAngpaoReceivedCls", function () {
    var $btnAngpaoClose = $('#btnAngpaoReceivedClose');
    if ($btnAngpaoClose.length > 0) $btnAngpaoClose[0].click();
    $btnAngpaoClose = undefined;
});

$(document).on('click', "#btnGiftboxReceivedCls", function () {
    var $btnGiftBoxClose = $('#btnGiftboxReceivedClose');
    if ($btnGiftBoxClose.length > 0) $btnGiftBoxClose[0].click();
    $btnGiftBoxClose = undefined;
});

function notify_angpao() {
    $.ajax({
        url: apiUrl + 'getAngpaoNotificationPWA',
    	type: "POST",
    	data:  {
    	    cid:sCid,
    	    ctoken:sToken,
    	},
    	success: function(data){
    		if (data !== undefined) {
    		    var $obj = JSON.parse(data);
    		    //console.log($obj);
    		    if ($obj.status === 1) {
    		        if (typeof $obj.angpao_id !== undefined && typeof $obj.angpao_amount !== undefined, typeof $obj.wallet_type !== undefined) {
    		            
    		            localStorage.setItem("yes2dAngpaoId", $obj.angpao_id);
    		            localStorage.setItem("yes2dAngpaoAmount", $obj.angpao_amount);
    		            var $alertAngpao = $('#alertAngpao'), lblPoint = document.getElementById("lblPoint");
    		            
    		            if ($alertAngpao.length > 0) $alertAngpao[0].click();
    		            if (lblPoint !== null) lblPoint.innerHTML = "You have received " + $obj.angpao_amount + " pt";
    		            
    		            $alertAngpao = undefined;
    		        }
    		    }
    		    else if ($obj.status === 2){
		            forceLogout($obj.msg);
    		    }
    		    else {
    		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
    		        
    		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
    		        if ($alertError.length > 0) $alertError[0].click();
    		        
    		        divErrorContent = undefined;
    		        $alertError = undefined;
    		    }
    		}
    	},
    	error: function(XMLHttpRequest, textStatus, errorThrown){
    		console.log(XMLHttpRequest.responseText);
    		console.log(textStatus);
    		console.log(errorThrown);
    	} 	        
    });
}

function notify_transfer711() {
    $.ajax({
        url: apiUrl + 'getUpdateTransfer711NotificationPWA',
    	type: "POST",
    	data:  {
    	    cid:sCid,
    	    ctoken:sToken,
    	},
    	success: function(data){
    		if (data !== undefined) {
    		    var $obj = JSON.parse(data);
    		    console.log($obj);
    		    if ($obj.status === 1) {

                    var divSuccessContent = document.getElementById("divSuccessContent"), $alertSuccess = $('#alertSuccess');
        							
                    if (divSuccessContent !== null) divSuccessContent.innerHTML = $obj.msg;
                    if ($alertSuccess.length > 0) $alertSuccess[0].click();
                    
                    divSuccessContent = undefined;
                    $alertSuccess = undefined;

                    firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                    const new_loop=parseInt(snapshot.val().Transfer711)
                        if(new_loop > 0){
                            firebase.database().ref("Customer/User/" + sCid).update({Transfer711: new_loop-1})
                        }
                    });

    		    }
    		    else if ($obj.status === 2){
		            forceLogout($obj.msg);
    		    }
    		    else {
    		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
    		        
    		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
    		        if ($alertError.length > 0) $alertError[0].click();
    		        
    		        divErrorContent = undefined;
    		        $alertError = undefined;
    		    }
    		}
    	},
    	error: function(XMLHttpRequest, textStatus, errorThrown){
    		console.log(XMLHttpRequest.responseText);
    		console.log(textStatus);
    		console.log(errorThrown);
    	} 	        
    });
}

function notify_turnover() {
    $.ajax({
        url: apiUrl + 'getUpdateTurnOverNotificationPWA',
    	type: "POST",
    	data:  {
    	    cid:sCid,
    	    ctoken:sToken,
    	},
    	success: function(data){
    		if (data !== undefined) {
    		    var $obj = JSON.parse(data);
    		    console.log($obj);
    		    if ($obj.status === 1) {

                    var divSuccessContent = document.getElementById("divSuccessContent"), $alertSuccess = $('#alertSuccess');
        							
                    if (divSuccessContent !== null) divSuccessContent.innerHTML = $obj.msg;
                    if ($alertSuccess.length > 0) $alertSuccess[0].click();
                    
                    divSuccessContent = undefined;
                    $alertSuccess = undefined;

                    firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                        firebase.database().ref("Customer/User/" + sCid).update({TurnoverNoti: 0})
                    });

    		    }
    		    else if ($obj.status === 2){
		            forceLogout($obj.msg);
    		    }
    		    else {
    		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
    		        
    		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
    		        if ($alertError.length > 0) $alertError[0].click();
    		        
    		        divErrorContent = undefined;
    		        $alertError = undefined;
    		    }
    		}
    	},
    	error: function(XMLHttpRequest, textStatus, errorThrown){
    		console.log(XMLHttpRequest.responseText);
    		console.log(textStatus);
    		console.log(errorThrown);
    	} 	        
    });
    
}

$(document).on('click', "#btnClaimGiftbox", function () {
    var divLoader = document.getElementById("loader"), $btnGiftboxClose = $('#btnGiftboxClose');
    if (divLoader !== null) divLoader.style.display="";
    
    if (typeof sCid !== undefined && typeof sToken !== undefined) {
        $.ajax({
            url: apiUrl + 'getApproveGiftboxPWA',
        	type: "POST",
        	data:  {
        	    cid:sCid,
        	    ctoken:sToken,
        	    giftboxid: localStorage.getItem("yes2dGiftboxId")
        	},
        	success: function(data){
        		if (data !== undefined) {
        		    var $obj = JSON.parse(data);
        		    //console.log($obj);
        		    if ($obj.status === 1) {
        		        console.log("claimGiftbox");
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        var divYescoin = document.getElementById("yescoin"),$alertGiftboxReceived = $('#alertGiftboxReceived');

        		        if ($btnGiftboxClose.length > 0) $btnGiftboxClose[0].click();
        		        
        		        if (typeof $obj.latest_balance !== typeof undefined) {
        		            if (divYescoin !== null) divYescoin.innerHTML = $obj.latest_balance;    
        		        }

                        if ($alertGiftboxReceived.length > 0) $alertGiftboxReceived[0].click();

        		        localStorage.setItem("yes2dGiftboxId", '');
                        localStorage.setItem("yes2dGiftboxAmount", '');
        		        
        		        firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                          const new_loop=parseInt(snapshot.val().GiftboxNoti)
                          firebase.database().ref("Customer/User/" + sCid).update({GiftboxNoti: new_loop-1})
        		        });

        		        divLoader = undefined;
        		        $alertGiftboxReceived = undefined;
        		    }
        		    else if ($obj.status === 2){
    		            forceLogout($obj.msg);
        		    }
        		    else {
        		        var divLoader = document.getElementById("loader");
        		        if (divLoader !== null) divLoader.style.display="none";
        		        
        		        if ($btnGiftboxClose.length > 0) $btnGiftboxClose[0].click();
        		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
        		        
        		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
        		        if ($alertError.length > 0) $alertError[0].click();
        		        
        		        divErrorContent = undefined;
        		        $alertError = undefined;
        		    }
        		}
        	},
        	error: function(XMLHttpRequest, textStatus, errorThrown){
        		console.log(XMLHttpRequest.responseText);
        		console.log(textStatus);
        		console.log(errorThrown);
        	} 	        
        });
    }
});

$(document).on('click', "#btnCancelGiftbox", function () {
    var divLoader = document.getElementById("loader"), $btnGiftboxClose = $('#btnGiftboxClose');
    if (divLoader !== null) divLoader.style.display="";
    if ($btnGiftboxClose.length > 0) $btnGiftboxClose[0].click();
    if (divLoader !== null) divLoader.style.display="none";
    localStorage.setItem("yes2dGiftboxId", '');
    localStorage.setItem("yes2dGiftboxAmount", '');
});

function notify_giftbox() {
    $.ajax({
        url: apiUrl + 'getGiftboxNotificationPWA',
    	type: "POST",
    	data:  {
    	    cid:sCid,
    	    ctoken:sToken,
    	},
    	success: function(data){
    		if (data !== undefined) {
    		    var $obj = JSON.parse(data);
    		    //console.log($obj);
    		    if ($obj.status === 1) {
    		        if (typeof $obj.giftbox_id !== undefined && typeof $obj.gitftbox_amount !== undefined, typeof $obj.wallet_type !== undefined) {
    		            
    		            localStorage.setItem("yes2dGiftboxId", $obj.giftbox_id);
    		            localStorage.setItem("yes2dGiftboxoAmount", $obj.gitftbox_amount);
    		            var $alertGiftbox = $('#alertGiftbox'), lblGiftBoxPoint = document.getElementById("lblGiftBoxPoint");
    		            
    		            if ($alertGiftbox.length > 0) $alertGiftbox[0].click();
    		            if (lblGiftBoxPoint !== null) lblGiftBoxPoint.innerHTML = "You have received " + $obj.gitftbox_amount + " pt";
    		            
    		            $alertGiftbox = undefined;
    		            lblGiftBoxPoint = undefined;
    		        }
    		    }
    		    else if ($obj.status === 2){
		            forceLogout($obj.msg);
    		    }
    		    else {
    		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
    		        
    		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
    		        if ($alertError.length > 0) $alertError[0].click();
    		        
    		        divErrorContent = undefined;
    		        $alertError = undefined;
    		    }
    		}
    	},
    	error: function(XMLHttpRequest, textStatus, errorThrown){
    		console.log(XMLHttpRequest.responseText);
    		console.log(textStatus);
    		console.log(errorThrown);
    	} 	        
    });
}
/*
function isPwa() {     
    var displayModes = ["fullscreen", "standalone", "minimal-ui"];     
    return displayModes.some((displayMode) => window.matchMedia('(display-mode: ' + displayMode + ')').matches); 
    
}

function getPWADisplayMode() {
  const isStandalone = window.matchMedia('(display-mode: standalone)').matches;
  if (document.referrer.startsWith('android-app://')) {
    return true;
  } else if (navigator.standalone || isStandalone) {
    return true;
  }
  else {
      const queryString = window.location.search;
      if (queryString !== undefined && queryString !== null) {
          const urlParams = new URLSearchParams(queryString);
          if (urlParams !== '') {
              const bUrlFullScreen = urlParams.get('fullscreen');
              if (bUrlFullScreen !== undefined) {
                  if (bUrlFullScreen !== null && bUrlFullScreen!== '') {
                      if (bUrlFullScreen === 'true') return true;
                  }
              }
          }
      }
      
  }
  return false;
}
*/

document.addEventListener('readystatechange', event => { 
    // When window loaded ( external resources are loaded too- `css`,`src`, etc...) 
    if (event.target.readyState === "complete") {
        // Go Back Button
        var goBackButton = document.querySelectorAll(".goBack");
        goBackButton.forEach(function (el) {
            el.addEventListener("click", function () {
                if (Finapp.Animation.goBack) {
                    goBackAnimation();
                }
                else {
                    window.history.go(-1);
                }
        
            })
        })
        //-----------------------------------------------------------------------
        // Tooltip
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
        //-----------------------------------------------------------------------
        
        
        //-----------------------------------------------------------------------
        // Fix for # href
        //-----------------------------------------------------------------------
        var aWithHref = document.querySelectorAll('a[href*="#"]');
        aWithHref.forEach(function (el) {
            el.addEventListener("click", function (e) {
                e.preventDefault();
            })
        });
        
        /*
        if (getPWADisplayMode()) {
            //alert("test");
            var eleBody = document.body; // Make the body go full screen.

            if (eleBody.requestFullscreen) {
                eleBody.requestFullscreen();
            } else if (eleBody.webkitRequestFullscreen) { 
                eleBody.webkitRequestFullscreen();
            } else if (eleBody.msRequestFullscreen) { 
                eleBody.msRequestFullscreen();
            }
        }
        */
        //alert(window.location.href);
        //alert(getPWADisplayMode());
        //-----------------------------------------------------------------------
        // Carousel
        // Splide Carousel
        // Full Carousel
        /*
        document.querySelectorAll('.carousel-full').forEach(carousel => new Splide(carousel, {
            perPage: 1,
            rewind: true,
            type: "loop",
            gap: 0,
            arrows: false,
            pagination: false,
        }).mount());
    
        // Single Carousel
        document.querySelectorAll('.carousel-single').forEach(carousel => new Splide(carousel, {
            perPage: 3,
            rewind: true,
            type: "loop",
            gap: 16,
            padding: 16,
            arrows: false,
            pagination: false,
            breakpoints: {
                768: {
                    perPage: 1
                },
                991: {
                    perPage: 2
                }
            }
        }).mount());
    
        // Multiple Carousel
        document.querySelectorAll('.carousel-multiple').forEach(carousel => new Splide(carousel, {
            perPage: 4,
            rewind: true,
            type: "loop",
            gap: 16,
            padding: 16,
            arrows: false,
            pagination: false,
            breakpoints: {
                768: {
                    perPage: 2
                },
                991: {
                    perPage: 3
                }
            }
        }).mount());
    
        // Small Carousel
        document.querySelectorAll('.carousel-small').forEach(carousel => new Splide(carousel, {
            perPage: 9,
            rewind: false,
            type: "loop",
            gap: 16,
            padding: 16,
            arrows: false,
            pagination: false,
            breakpoints: {
                768: {
                    perPage: 4
                },
                991: {
                    perPage: 7
                }
            }
        }).mount());
    
        // Slider Carousel
        document.querySelectorAll('.carousel-slider').forEach(carousel => new Splide(carousel, {
            perPage: 1,
            rewind: false,
            type: "loop",
            gap: 16,
            padding: 16,
            arrows: false,
            pagination: true
        }).mount());
    
        // Stories Carousel
        document.querySelectorAll('.story-block').forEach(carousel => new Splide(carousel, {
            perPage: 16,
            rewind: false,
            type: "slide",
            gap: 16,
            padding: 16,
            arrows: false,
            pagination: false,
            breakpoints: {
                500: {
                    perPage: 4
                },
                768: {
                    perPage: 7
                },
                1200: {
                    perPage: 11
                }
            }
        }).mount());
        */
        //-----------------------------------------------------------------------

        
        
        //-----------------------------------------------------------------------
        
        if (typeof bLoginPage === 'undefined') {
            if (!bLogin) {
                if (typeof sCid !== undefined && sCid !== null) {
                    firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                      const iLogin = parseInt(snapshot.val().bLogin);
                      if (iLogin == 1 || isNaN(iLogin)) firebase.database().ref("Customer/User/" + sCid).update({bLogin: 0});
    		        });
                }
                window.location = '/reset';
            }
            else {
                if (typeof sCid !== undefined && sCid !== null) {
                    console.log("PWATEST");
                    firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                      const iLogin = parseInt(snapshot.val().bLogin);
                      const iDepPay = parseInt(snapshot.val().bOnDepPay);
                      const iDGDepPay = parseInt(snapshot.val().bOnDGDepPay);
                      const iEwaPay = parseInt(snapshot.val().bOnEwaPay);
                      if (iLogin == 0 || isNaN(iLogin)) firebase.database().ref("Customer/User/" + sCid).update({bLogin: 1});
                      if (iDepPay == 1 || isNaN(iDepPay)) firebase.database().ref("Customer/User/" + sCid).update({bOnDepPay: 0});
                      if (iDGDepPay == 1 || isNaN(iDGDepPay)) firebase.database().ref("Customer/User/" + sCid).update({bOnDGDepPay: 0});
                      if (iEwaPay == 1 || isNaN(iEwaPay)) firebase.database().ref("Customer/User/" + sCid).update({bOnEwaPay: 0});
    		        });
                }
            }
            
            setTimeout(function() {
                if (typeof sCid !== undefined && sCid !== null) {
                  firebase.database().ref("Customer/User/"+ sCid).on('value', snapshot => {
                    try{
                        /*firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                          //onst new_loop=parseInt(snapshot.val().AngpaoNoti)
                          firebase.database().ref("Customer/User/" + sCid).update({AngpaoNoti: 1})
        		        });*/
                      var TransferNotiPWA = snapshot.val().TransferNoti;
                      if (typeof TransferNotiPWA !== undefined) {
                        if (TransferNotiPWA > 0) {
                            notify_transfer();
                        }
                      }
                      var AngpaoNotiPWA = snapshot.val().AngpaoNoti;
                      if (typeof AngpaoNotiPWA !== undefined) {
                        if (AngpaoNotiPWA > 0) {
                            notify_angpao();
                        }
                      }
                      var GiftboxNotiPWA = snapshot.val().GiftboxNoti;
                      if (typeof GiftboxNotiPWA !== undefined) {
                        if (GiftboxNotiPWA > 0) {
                            notify_giftbox();
                        }
                      }
                      var Transfer711PWA = snapshot.val().Transfer711;
                      if (typeof TransferNotiPWA !== undefined) {
                        if (Transfer711PWA > 0) {
                            notify_transfer711();
                        }
                      }
                      
                      var TurnoverPWA = snapshot.val().TurnoverNoti;
                      if (typeof TurnoverPWA !== undefined) {
                        if (TurnoverPWA > 0) {
                            notify_turnover();
                        }
                      }
                      
                    }
                    catch {
                      console.log('Firebase no client update');
                    }
                  });
                  
                  /*
                  firebase.database().ref("Customer/User/" + sCid).once('value', snapshot => {
                      firebase.database().ref("Customer/User/" + sCid).update({AngpaoNoti: 1})
                      firebase.database().ref("Customer/User/" + sCid).update({GiftboxNoti: 1})
    		        });
    		        */
                }
                
            }, 1500);
        }
    }
});

window.onerror = function(error, url, line) {
    //console.log({acc:'error', data:'ERR:'+error+' URL:'+url+' L:'+line});
    if (document.URL !== 'https://yes2d888.com/deposit_ewallet' && document.URL !== 'https://yes2d888.com/deposit_online' && document.URL !== 'https://yes2d888.com/deposit_telco'
    && document.URL !== 'https://yes2d888.com/register_account' && document.URL !== 'https://yes2d888.com/register' && document.URL !== 'https://yes2d888.com/deposit_online_dg'
    && document.URL !== 'https://yes2d888.com/deposit_online_pg' && document.URL !== 'https://yes2d888.com/deposit_ewallet_pg'
    && document.URL !== 'https://yes2d888.com/deposit_online_thb') {
        alert("Test Debug: " + error);
        //location.reload();
    }
    //return false;
};
