var objInfo = {}, divLoader = document.getElementById("loader");

function verifyQRMsg (val) {
    if (divLoader !== null) divLoader.style.display="";
    
    $.ajax({
        url: apiUrl + 'getDecryptQRStrPWA',
    	type: "POST",
    	data:  {
    	    cid:sCid,
    	    ctoken:sToken,
    	    qrMsg: val
    	},
    	success: function(data){
    		if (data !== undefined) {
    		    var $obj = JSON.parse(data);

    		    if ($obj.status === 1) {
    		        if(typeof $obj.customer_username !== undefined) {
    		            localStorage.setItem("yes2dTransferName", $obj.customer_username);
    		            window.location = '/transfer_code';
    		        }
    		    }
    		    else if ($obj.status === 2){
		            forceLogout($obj.msg);
    		    }
    		    else {
    		        if (divLoader !== null) divLoader.style.display="none";
    		        var divErrorContent = document.getElementById("divErrorContent"), $alertError = $('#alertError');
    		        
    		        if (divErrorContent !== null) divErrorContent.innerHTML = $obj.msg;
    		        if ($alertError.length > 0) $alertError[0].click();
    		        
    		        divErrorContent = undefined;
    		        $alertError = undefined;
    		        //scanner.start();
    		    }
    		}
    	},
    	error: function(XMLHttpRequest, textStatus, errorThrown){
    		console.log(XMLHttpRequest.responseText);
    		console.log(textStatus);
    		console.log(errorThrown);
    	} 	        
    });
}

$( document ).ready(function() {
    

     // This method will trigger user permissions
      Html5Qrcode.getCameras().then(devices => {
        if (devices && devices.length) {
          var cameraId = devices[0].id;
          const html5QrCode = new Html5Qrcode("reader");
          const qrCodeSuccessCallback = (decodedText, decodedResult) => {
              verifyQRMsg(decodedText);
          };
          const config = {
            fps: 10,
            qrbox: {
              width: 250,
              height: 250
            },
            aspectRatio: 1.7777778,
          };
          html5QrCode.start({
            facingMode: "environment"
          }, config, qrCodeSuccessCallback);
        }
      }).catch(err => {
        // handle err
        alert(`Error scanning file. Reason: ${err}`);
        //alert("Error. Please contact administrator"); 
      });
      
    const html5QrCode = new Html5Qrcode(/* element id */ "reader"); 

    // File based scanning
    const fileinput = document.getElementById('qr-input-file');
    fileinput.addEventListener('change', e => {
      if (e.target.files.length == 0) {
        	// No file selected, ignore 
            return; 
        }
        
        // Use the first item in the list
        const imageFile = e.target.files[0];
        html5QrCode.scanFile(imageFile, /* showImage= */true)
        .then(qrCodeMessage => {
        	// success, use qrCodeMessage 
            //alert(qrCodeMessage); 
            verifyQRMsg(qrCodeMessage);
         })
        .catch(err => {
        	// failure, handle it. 
           alert(`Error scanning file. Reason: ${err}`);
           
           location.reload(); //Refresh the page

        });
    });

});
