<?php 

// ---- DB SETTINGS ----
// Database connection settings
$servername = "localhost";
$username = "mlkks_master_user";
$password = "9#!gi!G(423o";
$dbname = "mlkks_master_db";

// ---- API SETTINGS ----
define('API_BASE_URL', 'https://yop1.kiss918.cc/'); // <-- replace
    $trader = 'my918kiss';
    $agent = 'mysbchos18';
    $secretkey = 'CXyVMyhRxHQdrlr';
    $authcode = 'C9kBr9O9';
    $pageurl   = 'kiss918-api/game_list'; // e.g. "api/game_list"

// --- Connect DB ---
$mysqli = new mysqli($servername, $username, $password, $dbname);
if ($mysqli->connect_error) {
  http_response_code(500);
  die("DB connection failed: " . $mysqli->connect_error);
}
$mysqli->set_charset("utf8mb4");

$sign = md5($agent . $trader . $secretkey);

$postData = [
  'sign'     => $sign,
  'trader'   => $trader,
  'agent'    => $agent,
];

$ch = curl_init();
curl_setopt_array($ch, [
  CURLOPT_URL            => rtrim(API_BASE_URL, '/') . '/' . ltrim($pageurl, '/'),
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_TIMEOUT        => 15,
  CURLOPT_POST           => true,
  CURLOPT_POSTFIELDS     => json_encode($postData, JSON_UNESCAPED_UNICODE),
  CURLOPT_HTTPHEADER     => [
      'Content-Type: application/json; charset=utf-8',
  ],
]);

$response = curl_exec($ch);

header('Content-Type: application/json');
echo $response;


if ($response === false) {
  $err = curl_error($ch);
  curl_close($ch);
  http_response_code(502);
  die("API request failed: $err");
}
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
if ($httpCode < 200 || $httpCode >= 300) {
  http_response_code(502);
  die("API returned HTTP $httpCode with body: " . htmlspecialchars(substr($response, 0, 500)));
}

// --- Decode JSON ---
$data = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
  http_response_code(500);
  die("Invalid JSON from API: " . json_last_error_msg());
}


if (!is_array($data)) {
  http_response_code(500);
  die("Unexpected API structure.");
}

$games = $data['data']['list'] ?? [];


if (!is_array($games)) {
  http_response_code(500);
  die("Games list not found in API response.");
}

$mysqli->begin_transaction();
try {
  $stmt = $mysqli->prepare("
    INSERT INTO cnf_kiss_gamelist (id, name, type, close)
    VALUES (?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
      id = VALUES(id),
      name = VALUES(name),
      type = VALUES(type),
      close = VALUES(close)
  ");

  if (!$stmt) {
    throw new Exception("Prepare failed: " . $mysqli->error);
  }

  $count = 0;
  foreach ($games as $g) {
    // Map fields safely; change keys to match your API
    $gameId     = (string)($g['game_id']   ?? $g['id'] ?? '');
    $name       = (string)($g['name']      ?? '');
    $type       = (string)($g['type']  ?? 'KS');
    $close      = (int)   ($g['close']    ?? 1);

    if ($gameId === '' || $name === '') {
      // Skip invalid rows
      continue;
    }

    $stmt->bind_param("issi", $gameId, $name, $type, $close);
    if (!$stmt->execute()) {
      throw new Exception("Insert failed for game_id {$gameId}: " . $stmt->error);
    }
    $count++;
  }

  $stmt->close();
  $mysqli->commit();

  // --- Simple browser output ---
  header('Content-Type: text/plain; charset=utf-8');
  echo "OK: upserted {$count} game(s)\n";

} catch (Exception $e) {
  $mysqli->rollback();
  http_response_code(500);
  echo "DB error: " . $e->getMessage();
} finally {
  $mysqli->close();
}

?>