<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="assets/js/jquery-3.6.3.min.js" type="text/javascript"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <title>918Kiss H5 Casino Game</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background:
                linear-gradient(135deg, #1a003300, #0a1931),
                url("../assets/img/kissbg.webp");
            /* <-- your image path */
            background-size: cover;
            /* make sure image covers the viewport */
            background-position: center;
            /* center the image */
            background-attachment: fixed;
            /* optional: parallax effect */
            color: #f8f8f2;
            margin: 0;
        }

        .container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
        }

        .game {
            position: relative;
            background: linear-gradient(145deg, #4b006e, #1e3c72);
            color: #FFD700;
            border: 2px solid rgba(255, 215, 0, 0.6);
            /* gold border */
            border-radius: 12px;
            margin: 10px;
            overflow: hidden;
            width: 200px;
            text-align: center;
            box-shadow: 0 0 15px rgba(255, 215, 0, 0.4);
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .game:hover {
            transform: scale(1.05);
            cursor: pointer;
            /* Change cursor to pointer on hover */
            box-shadow: 0 0 25px rgba(255, 215, 0, 0.8);
        }

        .thumbnail-container {
            position: relative;
            width: 100%;
            padding-top: 100%;
            /* 1:1 Aspect Ratio */
        }

        .thumbnail {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: contain;
            /* Contain within the container */
            border-bottom: 1px solid rgba(255, 215, 0, 0.4);
        }

        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(36, 23, 55, 0.6);
            display: none;
            justify-content: center;
            align-items: center;
            transition: background-color 0.2s;
        }

        .game:hover .overlay {
            display: flex;
            /* Show overlay on hover */
        }

        .play-now-button {
            background: linear-gradient(45deg, #FFD700, #FFA500);
            color: #000;
            border: none;
            padding: 10px 10px;
            font-size: 16px;
            font-weight: bold;
            border-radius: 6px;
            cursor: pointer;
            box-shadow: 0 0 10px rgba(255, 215, 0, 0.7);
            transition: background 0.3s, box-shadow 0.3s;
            margin-left: 10px;
            margin-right: 10px;
        }

        .play-now-button:hover {
            background: linear-gradient(45deg, #ffed4a, #ff9900);
            box-shadow: 0 0 15px rgba(255, 215, 0, 1);
        }

        .game-title {
            font-size: 1.2em;
            /*margin: 10px 0;*/
            padding: 0 10px;
            overflow: hidden;
            color: #FFD700;
            text-overflow: ellipsis;
        }

        @media (max-width: 768px) {
            .game {
                width: calc(28% - 5px);
                /* Four items per row */
            }

            .game-title {
                font-size: 1em;
            }
        }

        /* Floating button */
        .scroll-top-button,
        .clear-storage-button{
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: linear-gradient(45deg, #FFD700, #FFA500);
            color: white;
            border: none;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            font-size: 24px;
            cursor: pointer;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            transition: background-color 0.2s;
        }
        .gameLogs-storage-button{
        linear-gradient(45deg, #FFD700, #FFA500);
            background: linear-gradient(45deg, #FFD700, #FFA500);
            color: white;
            border-radius: 6px;
            height: 30px;
        }
        .scroll-top-button:hover,
        .clear-storage-button:hover,
        .gameLogs-storage-button:hover {
            background-color: #c0392b;
        }

        .clear-storage-button {
            left: 20px;
        }

        .search-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .search-bar {
            padding: 10px;
            font-size: 16px;
            width: 80%;
            max-width: 400px;
            border-radius: 8px;
            border: 2px solid rgba(255, 215, 0, 0.6);
            background: rgba(0, 0, 0, 0.3);
            color: #FFD700;
        }

        .search-bar:focus {
            outline: none;
            border-color: #FFD700;
            box-shadow: 0 0 8px rgba(255, 215, 0, 0.8);
        }

        header {
            text-align: center;
            background: transparent;
            padding:20px;
            margin-bottom: 20px;
            border-bottom: 2px solid rgba(255, 215, 0, 0.4);
        }
        }

       #log-overlay {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    z-index: 9999; /* 保证在最上层 */
    background: white;
    padding: 20px;
    border: 2px solid #444;
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.4);
    text-align: center;
    max-width: 95vw;
    max-height: 90vh;
    overflow-y: auto;
}
    </style>
</head>

<body>
    <!--<div style="background: linear-gradient(145deg, #4b006eab, #1e3c72d6);-->
    <!--        position: relative; -->
    <!--        width: 100%; ">-->
    <!--    <header><img src="/assets/img/918kiss.webp" style="width:200px" alt="918kiss"/></header>-->
    <!--    <div id="playerBox" style="position: absolute; bottom: 10px; left: 10px; ">-->
    <!--    <div style="position: absolute; bottom: 10px; right: 10px; ">918Kiss H5</div>-->
    <!--</div>-->
    <div style="background: linear-gradient(145deg, #4b006eab, #1e3c72d6);
            position: relative; 
            width: 100%; 
            color: rgba(255, 215, 0, 1);">

    <header>
        <img src="/assets/img/918kiss.webp" style="width:200px" alt="918Kiss H5"/>
    </header>

    <!-- Bottom right -->
    <!--div style="position: absolute; bottom: 10px; left: 10px;">
        918Kiss H5
    </div-->
    
    <!-- Bottom left -->
    <div id="playerBox" style="position: absolute; bottom: 10px; left: 10px;">
    </div>
   <div id="GameLogs" style="position: absolute; bottom: 10px; right: 10px;">
    <button class="gameLogs-storage-button" onclick="getGameLogs()">Game Log</button></div>


</div>

    </div>
    
        <!-- Bottom left -->

        <div id="log-overlay" style="text-align: center;  position: absolute; top: 50%;left: 50%;transform: translate(-50%, -50%);
            z-index: 9999; 
            background: #220f38;
            padding: 20px;
            border: 2px solid #444;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.4);
            text-align: center;
            max-width: 95vw;
            max-height: 90vh;
            overflow-y: auto;
            display:none;">
        <button onclick="document.getElementById('log-overlay').style.display='none'" style="position: absolute; top: 10px; left: 10px;">X</button>
        <div id="log-output-container" style="display: inline-block; max-width: 100%;">
            <div id="log-output"></div>
            <div id="pagination-controls" style="margin-top: 10px;"></div>
        </div>
    </div>
    
    <div class="search-container">
        <input type="text" id="search-bar" class="search-bar" placeholder="Search for games..." oninput="filterGames()">
    </div>

    <input type="hidden" id="launch-code-input">
    <div class="container" id="game-container">

    </div>

    <button class="scroll-top-button" onclick="scrollToTop()">
        <i class="fa-solid fa-arrow-up"></i>
    </button>

    <button class="clear-storage-button" onclick="clearLocalStorage()">
        <i class="fa-solid fa-rotate-right"></i>
    </button>


    <!-- Log Modal -->
    <!-- Simple Modal -->
    <div id="logModal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; 
     background:rgba(0,0,0,0.7); backdrop-filter: blur(4px);">
        <div style="background: linear-gradient(135deg, #4b006e, #1e3c72); 
              margin:8% auto; padding:20px; width:80%; max-width:600px; 
              border-radius:12px; 
              border: 3px solid #f3ae12; 
              background-clip: padding-box, border-box;
              background-origin: border-box;
              box-shadow: 0 0 25px rgba(255,215,0,0.6);
              color: #fff;
              position: relative;
              font-family: Arial, sans-serif;">

            <h3 style="margin-top:0; color:#FFD700; text-align:center; 0 0 12px #FFD700;">ALERT</h3>

            <pre id="logContent" style="white-space:pre-wrap; max-height:300px; overflow:auto; 
                background:rgba(0,0,0,0.4); padding:10px; 
                border-radius:8px; border:1px solid rgba(255,215,0,0.5); 
                color:#f8f8f2; font-size:14px;">
    </pre>

            <div style="text-align:center; margin-top:15px;">
                <button onclick="closeLog()" style="padding:8px 18px; border:none; border-radius:6px;
                     background: linear-gradient(45deg, #FFD700, #FFA500);
                     color:#000; font-weight:bold; 
                     box-shadow: 0 0 8px rgba(255,215,0,0.7); 
                     cursor:pointer;">
                    Close
                </button>
            </div>
        </div>
    </div>



    <script>

        function showLog(message) {
            if (typeof message === "object") {
                message = JSON.stringify(message, null, 2);
            }
            document.getElementById("logContent").innerText = message;
            document.getElementById("logModal").style.display = "block";
        }

        function closeLog() {
            document.getElementById("logModal").style.display = "none";
        }

        function fetchGames() {

            $.ajax({
                url: 'https://mlkksh5.com/get_game_list.php',
                type: 'GET',
                dataType: 'JSON',
                success: function (data) {
                    console.log(data);
                    localStorage.setItem('games', JSON.stringify(data));
                    games = data; // ✅ update global variable
                    renderGames(games);
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    alert("Error Occured, Please try again later.");
                    console.log(XMLHttpRequest.responseText);
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }

        function renderGames(games) {
            const container = document.getElementById('game-container');
            container.innerHTML = ''; // Clear existing content
            games.forEach(game => {
                const gameDiv = document.createElement('div');
                gameDiv.className = 'game';

                // Adding onclick function to call launchGame
                gameDiv.onclick = function () {
                    login(game.id);
                };


                const thumbnailContainer = document.createElement('div');
                thumbnailContainer.className = 'thumbnail-container';

                const thumbnail = document.createElement('img');
                thumbnail.className = 'thumbnail';
                thumbnail.src = 'https://yop1.kiss918.cc/doc/kiss918/icons/' + game.id + '.png';
                thumbnail.alt = game.name;
                thumbnail.onerror = function () {
                    this.onerror = null;
                    this.src = 'assets/pt_slot/not_found.jpg'; // Specify your fallback image path here
                };


                // Overlay for Play Now button
                const overlay = document.createElement('div');
                overlay.className = 'overlay';

                const playNowButton = document.createElement('button');
                playNowButton.className = 'play-now-button';
                playNowButton.textContent = 'Play Now';

                // Adding onclick function to call login with game's id
                playNowButton.onclick = function (event) {
                    event.stopPropagation(); // Prevent click from bubbling to gameDiv
                    login(game.id);
                };

                overlay.appendChild(playNowButton);
                thumbnailContainer.appendChild(thumbnail);
                thumbnailContainer.appendChild(overlay);

                const title = document.createElement('div');
                title.className = 'game-title';
                title.textContent = game.game_name;

                gameDiv.appendChild(thumbnailContainer);
                gameDiv.appendChild(title);

                container.appendChild(gameDiv);
            });
        }

        // Function to get the value of a specific URL parameter
        function getParameterByName(name, url = window.location.href) {
            name = name.replace(/[\[\]]/g, '\\$&');
            let regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, ' '));
        }

        // Function to decode a Base64 encoded string
        function base64Decode(str) {
            try {
                return atob(str);
            } catch (e) {
                console.error("Error decoding Base64: ", e);
                return null;
            }
        }

        let games = [];

        function scrollToTop() {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        }

        function clearLocalStorage() {
            localStorage.removeItem('games');
            const container = document.getElementById('game-container');
            container.innerHTML = ''; // Clear the game list display
            fetchGames(); // Fetch fresh data from the server
        }

        function filterGames() {
            const searchTerm = document.getElementById('search-bar').value.toLowerCase();
            const filteredGames = games.filter(game =>
                (game.game_name || game.name || "").toLowerCase().includes(searchTerm)
            );
            renderGames(filteredGames);
        }

        document.addEventListener("DOMContentLoaded", function () {
            // Check if the game list is in local storage
            const storedGames = localStorage.getItem('games');
            if (storedGames) {
                games = JSON.parse(storedGames);
                renderGames(games);
            } else {
                // Fetch game list from the server
                fetchGames();
            }
        });

        let launchCode, username, password, lang, mode, systemid;


        function login(launch_code) {
            const playerParam = 'playername';
            const pwdParam = 'pwd';
            const playername = getParameterByName(playerParam);
            const pwd = getParameterByName(pwdParam);

            $.ajax({
                url: 'https://mlkksh5.com/get_game_url.php',
                type: "POST",
                data: {
                    username: btoa(playername), // encode before sending
                    pwd: btoa(pwd),
                    gameid: launch_code,
                    language: 1,
                },
                async: true,
                dataType: 'json',
                success: function (data) {
                    //console.log('382'+data);
                    if (data.status == 1) {
                        window.location.href = data.url;
                    } else {
                        showLog("Error4: " + (data.msg || "Please try again"));
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showLog("AJAX Error: " + textStatus + " - " + errorThrown);
                }
            });
            
            
        }
            function getGameLogs(launch_code) {
                const playerParam = 'playername';
                const pwdParam = 'pwd';
                const playername = getParameterByName('playername');
                const pwd = getParameterByName('pwd');
                 document.getElementById('log-overlay').style.display = 'block';
                if (!playername || !pwd) {
                    showLog("Missing playername or password.");
                    return;
                }
            
                $.ajax({
                    url: 'https://mlkksh5.com/get_game_logs.php',
                    type: "POST",
                    data: {
                        username: btoa(playername), // base64 encode
                        pwd: btoa(pwd),
                        gameid: launch_code,
                        language: 1
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.status === 1 && Array.isArray(response.data)) {
                            // ✅ Successfully received game logs
                            displayGameLogs(response.data);
                        } else {
                            showLog("No logs found or error: " + (response.msg || "Unknown error"));
                        }
                    },
                    error: function (xhr, status, error) {
                        showLog("AJAX error: " + status + " - " + error);
                    }
                });
            }
            let allLogs = [];
            let currentPage = 1;
            const rowsPerPage = 15;
            
            function displayGameLogs(logs) {
                const outputDiv = document.getElementById('log-output');
                const paginationDiv = document.getElementById('pagination-controls');
            
                if (!outputDiv) return;
            
                allLogs = logs;
                currentPage = 1;
            
                if (logs.length === 0) {
                    outputDiv.innerHTML = "<p>No game logs available.</p>";
                    paginationDiv.innerHTML = "";
                    return;
                }
            
                renderTablePage(currentPage);
            }
            
            function renderTablePage(page) {
                const outputDiv = document.getElementById('log-output');
                const paginationDiv = document.getElementById('pagination-controls');
            
                const start = (page - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const pageLogs = allLogs.slice(start, end);
            
                let html = `
                    <table border='1' cellpadding='6' cellspacing='0' style='margin: auto;'>
                        <tr>
                            <th>Date</th>
                            <th>Username</th>
                            <th>GameID</th>
                             <th>Bet</th>
                            <th>Win</th>
                          
                      
                        </tr>
                `;
            
                pageLogs.forEach(log => {
                    html += `
                        <tr>
                            <td>${log.inserted_date}</td>
                            <td>${log.customer_game_username}</td>
                            <td>${log.GameID}</td>
                            <td>${log.bet}</td>
                            <td>${log.Win}</td>
                        </tr>`;
                });
            
                html += "</table>";
                outputDiv.innerHTML = html;
            
                renderPaginationControls(page);
            }
            
            function renderPaginationControls(current) {
                const paginationDiv = document.getElementById('pagination-controls');
                const totalPages = Math.ceil(allLogs.length / rowsPerPage);
            
                if (totalPages <= 1) {
                    paginationDiv.innerHTML = "";
                    return;
                }
            
                let controls = "";
            
                if (current > 1) {
                    controls += `<button onclick="goToPage(${current - 1})">Previous</button> `;
                }
            
                controls += ` Page ${current} of ${totalPages} `;
            
                if (current < totalPages) {
                    controls += ` <button onclick="goToPage(${current + 1})">Next</button>`;
                }
            
                paginationDiv.innerHTML = controls;
            }
            
            function goToPage(page) {
                currentPage = page;
                renderTablePage(page);
            }

        document.addEventListener("DOMContentLoaded", function () {
            const urlParams = new URLSearchParams(window.location.search);
            const q = urlParams.get('q'); // get ?q=123
            const playerParam = 'playername';
            const pwdParam = 'pwd';
            const playername = getParameterByName(playerParam);
            const pwd = getParameterByName(pwdParam);
        
            if (q == 1) {
                $.ajax({
                    url: 'https://mlkksh5.com/get_quit_game.php',
                    type: "POST",
                    data: {
                        username: btoa(playername), // encode before sending
                        pwd: btoa(pwd)
                    },
                    async: true,
                    dataType: 'json',
                    success: function (data) {
                        //console.log('382'+data);
                        if (data.status == 1) {
                            //showLog("Success: " + (data.msg || "Quit Game Success"));
                        } else {
                            showLog("Error: " + (data.msg || "Please try again"));
                        }
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        showLog("AJAX Error: " + textStatus + " - " + errorThrown);
                    }
                });
              
            } 
            
            const player = atob(playername);
document.getElementById("playerBox").innerHTML = '<i class="fa-solid fa-user"></i> : ' + player;

            
        });


    </script>


</body>

</html>